#include "bitmap1.hpp"

 WindowBitmap::WindowBitmap(HWND hwnd, COLORREF blankcol) //constructor
{
	HDC hdc;

	//To make checking for Release easier, if you need an hdc in a code
	//block, Get it in the first line and Release it in the last line.
	hdc = GetDC(hwnd);
	_CX = GetSystemMetrics(SM_CXSCREEN); //Actual size of screen
	_CY = GetSystemMetrics(SM_CYSCREEN); //measured in pixels.
	_hdc = CreateCompatibleDC(hdc); //Starts with area of one pixel!
	_hbitmap = CreateCompatibleBitmap(hdc, _CX, _CY);
		//This is really a memory allocation call as bitmap has size.
	if (!_hbitmap) //If there's not enough memory, tell & bail.
	{
		MessageBox( hwnd,
			(LPSTR)"Failure in Bitmap Allocation!",
			(LPSTR)"Memory Problems!",
			MB_OK | MB_ICONEXCLAMATION ); //Button flags
		SendMessage( hwnd, WM_DESTROY, 0, 0L ); //Goes to WndProc.
		return;
	}
	//Selecting _hbitmap here makes _hdc have _CX by _CY area.
	SelectObject(_hdc, _hbitmap);
	//Create the blankbrush.
	_hblankbrush = CreateSolidBrush(blankcol);
	Clear();
	//And get rid of the hdc you got in the first line.
	ReleaseDC(hwnd, hdc);
}

WindowBitmap::~WindowBitmap() //destructor
{
	/* First Delete the device context, and then i will be safe to delete the
	GDI objects that were selected into it.  Remember the rule is just
	that you can't delete a GDI tool while it is selected into a valid HDC. */
	DeleteDC(_hdc);
	//Delete the bitmap.
	DeleteObject(_hbitmap);
	//Delete the _hblankbrush.
	DeleteObject(_hblankbrush);
}

void WindowBitmap::Clear()
{ //This clears the bitmap.
	HBRUSH callerbrush;

	//Select the blankbrush.
	callerbrush = SelectObject(_hdc, _hblankbrush);
	//This covers the screen with the selected brush pattern.
	PatBlt(_hdc, 0, 0, _CX, _CY, PATCOPY);
	//Reselect the callerbrush, in case this  matters.
	SelectObject(_hdc, callerbrush);
}

void WindowBitmap::CopyTo(HDC hdc, RECT rect)
{
	BitBlt(hdc, rect.left, rect.top, //Next two arguments are width and height
		rect.right + 1 - rect.left, rect.bottom + 1 - rect.top,
		_hdc, rect.left, rect.top, SRCCOPY);
}

